﻿//////////////////////////////////////////////
// ComputePass.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class Shader ;
}

/// Includes ---------------------------------

// nkGraphics
#include "Pass.h"

#include "../Dll/DllDefines.h"
	
/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT ComputePass : public Pass
	{		
		public :
		
			// Getters
			Shader* getShader () const ;
			unsigned int getX () const ;
			unsigned int getY () const ;
			unsigned int getZ () const ;

			// Setters
			void setShader (Shader* shader) ;
			void setX (unsigned int value) ;
			void setY (unsigned int value) ;
			void setZ (unsigned int value) ;

			// Import / Export
			virtual void exportClassToTree (nkExport::Node* rootNode) override ;
			virtual void importClassFromTree (nkExport::Node* rootNode) override ;

		protected :

			// Functions
			// Constructor
			ComputePass (System* system) noexcept ;

		protected :

			// Attributes
			// Shader used
			Shader* _shader ;

			// Thread info
			unsigned int _xThreads ;
			unsigned int _yThreads ;
			unsigned int _zThreads ;
	} ;
}